<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Course extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;
    protected $guarded = array('id');
    protected $fillable = array('name', 'description', 'requirements', 'owner_id', 'rate');

    public function classes()
    {
        return $this->hasMany('App\Models\Class', 'course_id');
    }

    public function enrolled()
    {
        return $this->hasMany('App\Models\EnrolledCourse', 'course_id');
    }

}